/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StringFormatter {
    public static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Double) {
            Double d = (Double)o;
            return StringFormatter.toString(d);
        }
        if (o instanceof Float) {
            Float f = (Float)o;
            return StringFormatter.toString(f.floatValue());
        }
        if (o instanceof Throwable) {
            Throwable t = (Throwable)o;
            return StringFormatter.toString(t, Objects::toString);
        }
        if (o.getClass().isArray()) {
            return StringFormatter.arrayToString(o);
        }
        return o.toString();
    }

    public static String toString(double d) {
        double abs = Math.abs(d);
        if (abs >= 1000.0 || abs % 1.0 == 0.0) {
            return String.format(Locale.US, "%.0f", d);
        }
        if (abs >= 0.1) {
            return String.format(Locale.US, "%.4f", d);
        }
        return StringFormatter.toStringPrecise(d);
    }

    public static String toStringPrecise(double d) {
        if (d % 1.0 == 0.0) {
            return String.format(Locale.US, "%.0f", d);
        }
        return String.format(Locale.US, "%s", d);
    }

    public static String toString(float f) {
        float abs = Math.abs(f);
        if (abs >= 1000.0f || (double)abs % 1.0 == 0.0) {
            return String.format(Locale.US, "%.0f", Float.valueOf(f));
        }
        if (abs >= 0.1f) {
            return String.format(Locale.US, "%.4f", Float.valueOf(f));
        }
        return StringFormatter.toStringPrecise(f);
    }

    public static String toStringPrecise(float f) {
        if (f % 1.0f == 0.0f) {
            return String.format(Locale.US, "%.0f", Float.valueOf(f));
        }
        return String.format(Locale.US, "%s", Float.valueOf(f));
    }

    public static String methodToString(Class<?> owner, String name, Class<?> ... argTypes) {
        return owner.getName() + "." + name + (argTypes == null || argTypes.length == 0 ? "()" : Arrays.stream(argTypes).map(c -> c == null ? "null" : c.getName()).collect(Collectors.joining(",", "(", ")")));
    }

    public static String toString(Throwable t, Function<Throwable, String> stringify) {
        return stringify.apply(t) + "\n" + StringFormatter.getStackTrace(t, stringify);
    }

    public static String getStackTrace(Throwable t) {
        return StringFormatter.getStackTrace(t, Objects::toString);
    }

    public static String getStackTrace(Throwable t, Function<Throwable, String> stringify) {
        StringBuilder sb = new StringBuilder();
        StringFormatter.getStackTrace(sb, t, new StackTraceElement[0], "", "", Objects.requireNonNull(stringify), new HashSet<Throwable>(), true);
        return sb.toString();
    }

    private static void getStackTrace(StringBuilder sb, Throwable t, StackTraceElement[] enclosingTrace, String caption, String prefix, Function<Throwable, String> stringify, Set<Throwable> dejaVu, boolean skipHeader) {
        if (!skipHeader) {
            sb.append(prefix).append(caption);
        }
        if (!dejaVu.add(t)) {
            sb.append("[CIRCULAR REFERENCE: ").append(stringify.apply(t)).append("]\n");
            return;
        }
        StackTraceElement[] trace = t.getStackTrace();
        int m = trace.length - 1;
        for (int n = enclosingTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(enclosingTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        if (!skipHeader) {
            sb.append(stringify.apply(t)).append('\n');
        }
        for (int i = 0; i <= m; ++i) {
            sb.append(prefix).append("\tat ").append(trace[i]).append('\n');
        }
        if (framesInCommon != 0) {
            sb.append(prefix).append("\t... ").append(framesInCommon).append(" more").append('\n');
        }
        for (Throwable se : t.getSuppressed()) {
            StringFormatter.getStackTrace(sb, se, trace, "Suppressed: ", prefix + "\t", stringify, dejaVu, false);
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            StringFormatter.getStackTrace(sb, cause, trace, "Caused by: ", prefix, stringify, dejaVu, false);
        }
    }

    private static String arrayToString(Object array) {
        String string;
        Object object = array;
        int n = 0;
        block15: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{boolean[].class, byte[].class, char[].class, short[].class, int[].class, long[].class, float[].class, float[].class, double[].class, double[].class, Object[].class, Object[].class}, (Object)object, n)) {
                case -1: {
                    string = "null";
                    break block15;
                }
                case 0: {
                    boolean[] o = (boolean[])object;
                    string = Arrays.toString(o);
                    break block15;
                }
                case 1: {
                    byte[] o = (byte[])object;
                    string = Arrays.toString(o);
                    break block15;
                }
                case 2: {
                    char[] o = (char[])object;
                    string = Arrays.toString(o);
                    break block15;
                }
                case 3: {
                    short[] o = (short[])object;
                    string = Arrays.toString(o);
                    break block15;
                }
                case 4: {
                    int[] o = (int[])object;
                    string = Arrays.toString(o);
                    break block15;
                }
                case 5: {
                    long[] o = (long[])object;
                    string = Arrays.toString(o);
                    break block15;
                }
                case 6: {
                    float[] o = (float[])object;
                    if (o.length != 0) {
                        n = 7;
                        continue block15;
                    }
                    string = "[]";
                    break block15;
                }
                case 7: {
                    float[] o = (float[])object;
                    StringBuilder sb = new StringBuilder();
                    sb.append('[');
                    for (int i = 0; i < o.length; ++i) {
                        sb.append(StringFormatter.toString(o[i]));
                        if (i == o.length - 1) continue;
                        sb.append(", ");
                    }
                    sb.append(']');
                    string = sb.toString();
                    break block15;
                }
                case 8: {
                    double[] o = (double[])object;
                    if (o.length != 0) {
                        n = 9;
                        continue block15;
                    }
                    string = "[]";
                    break block15;
                }
                case 9: {
                    double[] o = (double[])object;
                    StringBuilder sb = new StringBuilder();
                    sb.append('[');
                    for (int i = 0; i < o.length; ++i) {
                        sb.append(StringFormatter.toString(o[i]));
                        if (i == o.length - 1) continue;
                        sb.append(", ");
                    }
                    sb.append(']');
                    string = sb.toString();
                    break block15;
                }
                case 10: {
                    Object[] o = (Object[])object;
                    if (o.length != 0) {
                        n = 11;
                        continue block15;
                    }
                    string = "[]";
                    break block15;
                }
                case 11: {
                    Object[] o = (Object[])object;
                    StringBuilder sb = new StringBuilder();
                    sb.append('[');
                    for (int i = 0; i < o.length; ++i) {
                        sb.append(StringFormatter.toString(o[i]));
                        if (i == o.length - 1) continue;
                        sb.append(", ");
                    }
                    sb.append(']');
                    string = sb.toString();
                    break block15;
                }
                default: {
                    string = array.toString();
                    break block15;
                }
            }
            break;
        }
        return string;
    }
}

